package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.VdesestimadosAperturas;
import com.ejie.ab04b.model.VdesestimadosOs3;
import com.ejie.ab04b.service.VdesestimadosOs3Service;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * VdesestimadosOs3Controller generated by UDA, 04-ago-2017 13:03:53.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/vdesestimadosos3")
public class VdesestimadosOs3Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(VdesestimadosOs3Controller.class);

	public static final String ATTR_NAME_DESESOS3_FILTER = "vdesestimientoOs3FiltroModel";

	@Autowired()
	private VdesestimadosOs3Service vdesestimadosOs3Service;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		VdesestimadosOs3Controller.logger
				.info("[GET - View] : vdesestimadosos3");

		// Combos del Filtro
		this.precargaCombosFiltroBusqueda(model);
		return "vdesestimadosos3";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterVdesestimadosOs3
	 *            VdesestimadosOs3 Bean que contiene los parametros de filtrado
	 *            a emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterVdesestimadosOs3 the filter vdesestimados os 3
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<VdesestimadosOs3> Dto que contiene el resultado
	 *         del filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<VdesestimadosOs3> filter(
			@RequestJsonBody(param = "filter") VdesestimadosOs3 filterVdesestimadosOs3,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		VdesestimadosOs3Controller.logger
				.info("[POST - filter] : Obtener VdesestimadosOs3s");
		return this.vdesestimadosOs3Service.filter(filterVdesestimadosOs3,
				jqGridRequestDto, false);
	}

	/**
	 * AÃ±ade al model los datos necesarios para la carga de los combos de la
	 * pantalla del filtro de busqueda.
	 * 
	 *  model            Model
	 *
	 * @param model the model
	 */
	private void precargaCombosFiltroBusqueda(Model model) {

		model.addAttribute("autoridades",
				UtilSeguridad.getInstance().obtenerDelegacionesUsuario());

		VdesestimadosAperturas desestimiento = new VdesestimadosAperturas();

		Calendar c = Calendar.getInstance();
		desestimiento.setAnoExp(String.valueOf(c.get(Calendar.YEAR)));

		model.addAttribute(VdesestimadosOs3Controller.ATTR_NAME_DESESOS3_FILTER,
				desestimiento);
	}
}
